/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.FitData;
import util.Logger;
import view.MainView;

public class FitAmbiguity
extends FitData {
    static Logger logger = Logger.getLogger();
    private int nodesout;

    public FitAmbiguity(MainView pView, int pnodes) {
        super(pView, pnodes);
        logger.entry(6, "FitAmbiguity.FitAmbiguity");
        this.extra = 10 * this.rangein;
        this.nodesout = this.nodesin * this.rangein;
        this.xout = new double[this.nodesout + 2 * this.extra];
        this.yout = new double[this.nodesout + 2 * this.extra];
        this.xinvert = new double[this.nodesout + 2 * this.extra];
        this.yinvert = new double[this.nodesout + 2 * this.extra];
        logger.exit(6, "FitAmbiguity.FitAmbiguity");
    }

    public void extrapolate() {
        logger.entry(6, "FitAmbiguity.extrapolate");
        int extrain = 10;
        double[] xin_e = new double[this.nodesin + 2 * extrain];
        double[] yin_e = new double[this.nodesin + 2 * extrain];
        int i = 0;
        while (i < extrain) {
            xin_e[i] = this.xin[this.nodesin - extrain + i] - 360.0;
            yin_e[i] = this.yin[this.nodesin - extrain + i] - 360.0;
            ++i;
        }
        i = 0;
        while (i < this.nodesin) {
            xin_e[extrain + i] = this.xin[i];
            yin_e[extrain + i] = this.yin[i];
            ++i;
        }
        i = 0;
        while (i < extrain) {
            xin_e[extrain + this.nodesin + i] = this.xin[i] + 360.0;
            yin_e[extrain + this.nodesin + i] = this.yin[i] + 360.0;
            ++i;
        }
        i = 0;
        while (i < this.xout.length) {
            int index = i / this.rangein;
            int rest = i % this.rangein;
            if (rest == 0) {
                this.xout[i] = xin_e[index];
                this.yout[i] = yin_e[index];
            } else if (index < this.nodesin + 2 * extrain - 1) {
                double slope = (yin_e[index + 1] - yin_e[index]) / (double)this.rangein;
                this.xout[i] = xin_e[index] + (double)rest;
                this.yout[i] = yin_e[index] + slope * (double)rest;
            }
            ++i;
        }
        logger.exit(6, "FitAmbiguity.extrapolate");
    }

    @Override
    public void fitCorr() {
        logger.entry(6, "FitAmbiguity.fitCorr");
        this.extrapolate();
        int start = this.extra;
        int stop = start + 1;
        while (stop < this.extra + this.nodesout + this.extra / 2) {
            double dy = this.yout[stop] - this.yout[start];
            logger.log(6, "start, stop, dy = " + start + ", " + stop + ", " + dy);
            if (dy > 0.1) {
                if (stop - start > 1) {
                    double slope = (this.yout[stop] - this.yout[start]) / (double)(stop - start);
                    int n = 1;
                    while (n < stop - start) {
                        this.yout[start + n] = this.yout[start] + slope * (double)n;
                        ++n;
                    }
                }
                start = stop;
                stop = start + 1;
                continue;
            }
            logger.log(6, "negative slope at: " + stop);
            ++stop;
        }
        this.invert();
        logger.exit(6, "FitAmbiguity.fitCorr");
    }
}

